// ==UserScript==
// @name         5ch レスダブルクリックでアンカー自動挿入
// @namespace    http://tampermonkey.net/
// @version      1.2
// @description  投稿をダブルクリックで>>番号を投稿フォームに挿入、未表示時はフォームを自動で開く
// @match        *://*.5ch.net/test/read.cgi/*
// @grant        none
// ==/UserScript==

(function () {
    'use strict';

    document.addEventListener('dblclick', function (e) {
        const post = e.target.closest('.post');
        if (!post || !post.dataset.id) return;

        const postId = post.dataset.id;
        let textarea = document.querySelector('#tmk_message');

        if (!textarea) {
            if (typeof window.createFormbox === 'function') {
                window.createFormbox();

                setTimeout(() => {
                    textarea = document.querySelector('#tmk_message');
                    if (textarea) {
                        textarea.value += `>>${postId}\n`;
                        textarea.focus();
                    }
                }, 200);
            } else {
                alert("投稿フォームの作成関数が見つかりません。フォームスクリプトに window.createFormbox = createFormbox; を追加してください。");
            }
        } else {
            textarea.value += (textarea.value ? '\n' : '') + `>>${postId}\n`;
            textarea.focus();
        }
    });
})();
